let Base = "/api",
    SingleUser = Base + "/single_user",
    Private = Base + "/private",
    Image = Base + "/image",
    ImagePage = Image + "/page",
    ImagePageField = (entry) => { return `${ImagePage}/${entry}` },
    ImagePageImage = (entry) => { return `${ImagePageField(entry)}/image` },
    ImageField = (flake) => { return `${Image}/${flake}` },
    ImageFile = (flake) => { return `${ImageField(flake)}/file` },
    ImagePreview = (flake) => { return `${ImageField(flake)}/preview` },
    ImageTag = (flake) => { return `${ImageField(flake)}/tag` },
    ImageTagField = (flake, tag) => { return `${ImageTag(flake)}/${tag}` },
    Tag = Base + "/tag",
    TagField = (tag) => { return `${Tag}/${tag}` },
    TagInfo = (tag) => `${TagField(tag)}/info`,
    TagPage = TagField + "/page",
    TagPageField = (entry) => { return `${TagPage}/${entry}` },
    TagPageImage = TagPageField + "/image",
    Search = Base + "/search",
    SearchField = (tags) => { return `${Search}/${tags}` },
    User = Base + "/user",
    UserThis = User + "/this",
    UserField = (flake) => { return `${User}/${flake}` },
    UserSecret = UserField + "/secret",
    UserImage = UserField + "/image",
    UserPassword = UserField + "/password",
    Username = Base + "/username",
    UsernameField = (name) => { return `${Username}/${name}` },
    UsernameAuth = (name) => `${UsernameField(name)}/auth`

export const paths = {
    Base: Base,
    SingleUser: SingleUser,
    Private: Private,
    Image: Image,
    ImagePage: ImagePage,
    ImagePageField: ImagePageField,
    ImagePageImage: ImagePageImage,
    ImageField: ImageField,
    ImageFile: ImageFile,
    ImagePreview: ImagePreview,
    ImageTag: ImageTag,
    ImageTagField: ImageTagField,
    Tag: Tag,
    TagField: TagField,
    TagInfo: TagInfo,
    TagPage: TagPage,
    TagPageField: TagPageField,
    TagPageImage: TagPageImage,
    Search: Search,
    SearchField: SearchField,
    User: User,
    UserThis: UserThis,
    UserField: UserField,
    UserSecret: UserSecret,
    UserImage: UserImage,
    UserPassword: UserPassword,
    Username: Username,
    UsernameField: UsernameField,
    UsernameAuth: UsernameAuth,
}