package main

import (
	"flag"
	"image"
	"image/color"
	"image/png"
	"io"
	"math"
	"os"
)

var err error

var (
	inFilePath string
	demodulate bool
)

var (
	in  []byte
	out io.Writer
)

func init() {
	flag.BoolVar(&demodulate, "d", false, "De-modulate data from a modulated image.")
}

func main() {
	flag.Parse()

	if flag.NArg() != 1 {
		println("Expected argument: infile.")
		os.Exit(1)
	}

	inFilePath = flag.Arg(0)

	if demodulate {
		de()
		os.Exit(0)
	}

	in, err = os.ReadFile(inFilePath)
	if err != nil {
		println("Error while reading input,", err)
		os.Exit(1)
	}

	l := int(math.Ceil(math.Sqrt(float64(len(in)))))
	h := int(math.Ceil(float64(len(in)) / float64(l)))
	println("Image length", l, "height", h)

	img := image.NewRGBA64(image.Rect(0, 0, l, h))
	c := 0
	for y := 0; y < h; y++ {
		for x := 0; x < l; x++ {
			if c >= len(in) {
				img.Set(x, y, color.RGBA{
					R: 255,
					G: 255,
					B: 255,
					A: 255,
				})
				continue
			}
			img.Set(x, y, color.RGBA{
				R: 0,
				G: 0,
				B: 0,
				A: in[c],
			})
			c++
		}
	}
	out, err = os.OpenFile("output.png", os.O_WRONLY|os.O_CREATE|os.O_TRUNC, 0644)
	if err != nil {
		println("Error while opening output,", err)
		os.Exit(1)
	}
	err = png.Encode(out, img)
	if err != nil {
		println("Error while encoding output,", err)
		os.Exit(1)
	}
}
