package main

import (
	"image"
	"os"
)

var inFile *os.File
var inImage image.Image
var format string
var outSlice []byte

func de() {
	inFile, err = os.Open(inFilePath)
	if err != nil {
		println("Error while opening input,", err)
		os.Exit(1)
	}
	inImage, format, err = image.Decode(inFile)
	if err != nil {
		println("Error while decoding input,", err)
		os.Exit(1)
	}

	if format != "png" {
		println("Expected png, got", format)
		os.Exit(1)
	}

	for y := 0; y < inImage.Bounds().Dy(); y++ {
		for x := 0; x < inImage.Bounds().Dx(); x++ {
			r, g, b, a := inImage.At(x, y).RGBA()
			if r == g && g == b && b == 0 {
				outSlice = append(outSlice, byte(a))
			}
		}
	}
	println("Output", len(outSlice), "bytes")
	err = os.WriteFile("output", outSlice, 0644)
	if err != nil {
		println("Error while writing output,", err)
		os.Exit(1)
	}
}
